
#ifndef __UMFH_H__
#define __UMFH_H__


#include <windows.h>

#ifdef __cplusplus
extern "C"
{
#endif

//===============================================
/*---------- Commond Functions--------*/
//===============================================
int _stdcall fw_init(int port,long baud); 
int _stdcall fw_exit(int icdev);
int _stdcall fw_des(unsigned char *key,unsigned char *sour,
				   unsigned char *dest,__int16 m);
__int16 __stdcall fw_config_card(HANDLE icdev,unsigned char flags);
__int16 _stdcall a_hex(unsigned char *a,unsigned char *hex,__int16 len);
void _stdcall hex_a(unsigned char *hex,unsigned char *a,__int16 len);
//===============================================
/*----------M1 Commond Functions--------*/
//===============================================

int _stdcall fw_card_hex(int icdev,unsigned char _Mode,unsigned char* Snrbuf);
int _stdcall fw_card(int icdev,unsigned char _Mode,unsigned long *_Snr);
int _stdcall fw_card_str(int icdev,unsigned char _Mode,unsigned char* strSnr);
int _stdcall fw_request(int icdev,unsigned char _Mode,unsigned int *TagType);
int _stdcall fw_anticoll(int icdev,unsigned char _Bcnt,unsigned long *_Snr);
int _stdcall fw_select(int icdev,unsigned long _Snr,unsigned char *_Size);
int _stdcall fw_load_key(int icdev,unsigned char _Mode,
				unsigned char _SecNr,unsigned char *_NKey);
int _stdcall fw_authentication(int icdev,unsigned char _Mode,
									   unsigned char _SecNr);
int _stdcall fw_authentication_pass(int icdev, unsigned char _Mode, unsigned char Addr,unsigned char *passbuff);
int _stdcall fw_read(int icdev,unsigned char _Adr,unsigned char *_Data);
__int16 __stdcall fw_read_hex(int icdev,unsigned char _Adr,unsigned char *_Data);
int _stdcall fw_write(int icdev,unsigned char _Adr,unsigned char *_Data);
__int16 __stdcall fw_write_hex(int icdev,unsigned char _Adr,unsigned char *_Data);
int _stdcall fw_halt(int icdev);
int _stdcall fw_changeb3(int icdev,unsigned char _SecNr,
				unsigned char *_KeyA,unsigned char *_CtrlW,unsigned char _Bk,
				unsigned char *_KeyB);
int _stdcall fw_changeb3_hex(int icdev,unsigned char _SecNr,
				unsigned char *_KeyA_hex,unsigned char *_CtrlW_hex,unsigned char _Bk,
				unsigned char *_KeyB_hex);
int _stdcall fw_initval(int icdev,unsigned char _Adr,unsigned long _Value);
int _stdcall fw_initval_dec(int icdev,unsigned char _Adr,double _Value);
int _stdcall fw_increment(int icdev,unsigned char _Adr,unsigned long _Value);
int _stdcall fw_increment_dec(int icdev,unsigned char _Adr,double _Value);
int _stdcall fw_readval(int icdev,unsigned char _Adr,unsigned long *_Value);
int _stdcall fw_readval_dec(int icdev,unsigned char _Adr,double *_Value);
int _stdcall fw_decrement(int icdev,unsigned char _Adr,unsigned long _Value);
int _stdcall fw_decrement_dec(int icdev,unsigned char _Adr,double _Value);
int _stdcall fw_restore(int icdev,unsigned char _Adr);
int _stdcall fw_transfer(int icdev,unsigned char _Adr);
int _stdcall fw_authentication_2(int icdev,unsigned char _Mode,unsigned char KeyNr,
						unsigned char Adr);
int _stdcall fw_authentication_pass(int icdev, unsigned char _Mode, 
											unsigned char Addr,
						   unsigned char *passbuff);

//===============================================
/*---------- device Functions--------*/
//===============================================
int _stdcall fw_beep(int icdev,unsigned int _Msec);
int _stdcall fw_disp_mode(int icdev,unsigned char mode);
int _stdcall fw_ctl_mode(int icdev,unsigned char mode);
int _stdcall fw_lcd_dispstr(int icdev,char *digit);
int _stdcall fw_gettime(int icdev,unsigned char *time);
int _stdcall fw_getver(int icdev,unsigned char *buff);
int _stdcall fw_high_disp(int icdev,unsigned char offset,
								  unsigned char disp_len,unsigned char *disp_str);
int _stdcall fw_lcd_setbright(int icdev,unsigned char bright);
int _stdcall fw_settime(int icdev,unsigned char *time);
int _stdcall fw_srd_eeprom(int icdev,int offset,int length,
								   unsigned char *rec_buffer);
int _stdcall fw_swr_eeprom(int icdev,int offset,int length,
								   unsigned char* buffer);
__int16 __stdcall fw_reset(HANDLE icdev,unsigned __int16 _Msec);
int _stdcall fw_lcd_dispclear(int icdev);
int _stdcall fw_LED_disp8(int icdev,unsigned char strlen,
								  unsigned char* dispstr);

int _stdcall IC_GetDevSN(int icdev, unsigned char* pbuf, int* rlen);
int _stdcall IC_GetDevCMSN(int icdev, unsigned char* pbuf, int* rlen);


//===============================================
//         4442 Commond Functions
//===============================================
int _stdcall fw_read_4442(int icdev,unsigned char _Adr,unsigned char *_Data,
								  int length);
int _stdcall fw_write_4442(int icdev,unsigned char _Adr,unsigned char *_Data,
								   int length);
int _stdcall fw_getProtectData_4442(int icdev,unsigned char _Adr,
											unsigned char *_Data,int length);
int _stdcall fw_setProtectData_4442(int icdev,unsigned char _Adr,
											unsigned char *_Data,int length);
int _stdcall fw_authentikey_4442(int icdev,unsigned char _Adr,int rlen,
										 unsigned char *key);
int _stdcall fw_changkey_4442(int icdev,unsigned char _Adr,int rlen,
									  unsigned char *key);
int _stdcall fw_cntReadError_4442(int icdev,unsigned char *cntReadError);

//===============================================
//         4428 Commond Functions
//===============================================
int _stdcall fw_read_4428(int icdev,unsigned int _Adr,unsigned char *_Data,
								  int length);
int _stdcall fw_write_4428(int icdev,unsigned int _Adr,unsigned char *_Data,
								   int length);
int _stdcall fw_getProtectData_4428(int icdev,unsigned int _Adr,
											unsigned char *_Data,int length);
int _stdcall fw_setProtectData_4428(int icdev,unsigned int _Adr,
											unsigned char *_Data,int length);
int _stdcall fw_authentikey_4428(int icdev,unsigned char *key);
int _stdcall fw_changkey_4428(int icdev,unsigned char *key);
int _stdcall fw_cntReadError_4428(int icdev,unsigned char *cntReadError);

//===============================================
//           cup(SAM)  Functions
//===============================================
__int16 __stdcall fw_cpureset(HANDLE ICDev,unsigned char *rlen, unsigned char *rbuff);
__int16 __stdcall fw_setcpu(HANDLE ICDev,unsigned char SAMID);
__int16 __stdcall fw_cpuapdu(HANDLE ICDev,unsigned char slen,unsigned char * sbuff,
						   unsigned char *rlen,unsigned char * rbuff);
__int16  __stdcall fw_cpuapdusource(HANDLE ICDev,unsigned char slen,
								 unsigned char * sbuff,unsigned char *rlen,
								 unsigned char * rbuff);
__int16 __stdcall fw_setcpupara(HANDLE ICDev,unsigned char cputype,
							  unsigned char cpupro,unsigned char cpuetu);
__int16 __stdcall fw_cpudown(int icdev,unsigned char cardtype);
__int16  __stdcall fw_attrib_ID(HANDLE icdev,unsigned char *UIDinfo, unsigned char *len);

//================================================
//S70 Functions
//S70 operation command most the same as M1
//================================================
int _stdcall fw_read_S70(int icdev,unsigned char _Adr,unsigned char *_Data);
int _stdcall fw_write_S70(int icdev,unsigned char _Adr,unsigned char *_Data);

//================================================
//     UltraLight card  Functions
//================================================
#define PAGE16_19	16
#define PAGE20_23	20
#define PAGE24_27	24
#define PAGE28_31	28
#define PAGE32_35	32
#define PAGE36_39	36
#define PAGE44_47	44

int _stdcall fw_request_ultralt(int icdev,unsigned char _Mode);
int _stdcall fw_anticall_ultralt(int icdev,unsigned long *_Snr);
int _stdcall fw_select_ultralt(int icdev,unsigned long _Snr);
int _stdcall fw_reqa_ultralt(int icdev,unsigned char _Bcnt,unsigned long _Snr);
int _stdcall fw_wakeup_ultralt(int icdev,unsigned char _Snr);
int _stdcall fw_read_ultralt(int icdev,unsigned char iPage,unsigned char *redata);
int _stdcall fw_write_ultralt(int icdev,unsigned char iPage,unsigned char *sdata);
int _stdcall fw_halt_ultralt(int icdev);
int _stdcall fw_ultralt_C_authen(int icdev, unsigned char* key);
/*
 ************************
 * Set as safe page
 * PARAMETERS:
	icdev: Handle of reader
	ipage: Number of page, 4 ~ 41
	readSec: Permissions of read.0 -> Read not need password; 1 Read need password;Note:Write always need password
 * RETURN: 0 is success, otherwise error code
 ************************
 */
int _stdcall fw_ultralt_C_setSafePage(int icdev, int ipage, BOOL readSec);
/*
 ************************
 * Change Password
 * PARAMETERS:
	icdev: Handle of reader
	keyold: Old password, 16 bytes
	keynew: New password, 16 bytes IN/OUT
 * RETURN: 0 is success, otherwise error code.
 ************************
 */
int _stdcall fw_ultralt_C_changePwd(int icdev, unsigned char* keyold,unsigned char* keynew);
/*
 ************************
 * Lock page. This operation cannot be reversed, the page locked won't be Rewrite
 * PARAMETERS:
   icdev: Handle of reader
   flag: The flag of page
         value be set:
		 3~15 match 3~15 
		 41~43 match 41~43
		 PAGE16_19 (16)match 16~19
		 PAGE20_23 (20)match 20~23
		 PAGE24_27 (24)match 24~27
		 PAGE28_31 (28)match 28~31
		 PAGE32_35 (32): match 32~35
		 PAGE36_39 (36)match 36~39
		 PAGE44_47 (44)match 44~47
 * RETURN: 0 is success, otherwise error code.
 ************************
 */
int _stdcall fw_ultralt_C_lockPage(int icdev, int flag);



//===============================================
//       MifarePro card  Functions
//===============================================
__int16 _stdcall fw_reset_mifarepro(int icdev,unsigned char *rlen, unsigned char *rbuff);
__int16 _stdcall fw_setcpu_mifarepro(int icdev,unsigned char SAMID);
__int16 _stdcall fw_apdu_mifarepro(int icdev,unsigned char slen,unsigned char * sbuff,
						   unsigned char *rlen,unsigned char * rbuff);
__int16 _stdcall fw_setpara_mifarepro(int icdev,unsigned char cputype,unsigned char cpupro,
							  unsigned char cpuetu);

//===============================================
//       Icode2 card  Functions
//===============================================

__int16 __stdcall fw_inventory(HANDLE icdev,unsigned char flags,
							   unsigned char AFI, 
							   unsigned char masklen, 
							   unsigned char *rlen,unsigned char *rbuffer);
__int16 __stdcall fw_stay_quiet(HANDLE icdev,unsigned char flags,unsigned char *UID);
__int16 __stdcall fw_select_uid(HANDLE icdev,unsigned char flags,unsigned char *UID);
__int16 __stdcall fw_reset_to_ready(HANDLE icdev,unsigned char flags,unsigned char *UID);
__int16 __stdcall fw_readblock(HANDLE icdev,unsigned char flags,
							   unsigned char startblock,unsigned char blocknum, 
							   unsigned char *UID, 
							   unsigned char *rlen,unsigned char *rbuffer);
__int16 __stdcall fw_writeblock(HANDLE icdev,unsigned char flags,
								unsigned char startblock,unsigned char blocknum, 
								unsigned char *UID, 
								unsigned char wlen,unsigned char *rbuffer);
__int16 __stdcall fw_lock_block(HANDLE icdev,unsigned char flags,unsigned char block,
								unsigned char *UID);
__int16 __stdcall fw_write_afi(HANDLE icdev,unsigned char flags,unsigned char AFI,
							   unsigned char *UID);
__int16 __stdcall fw_lock_afi(HANDLE icdev,unsigned char flags,unsigned char AFI,
							  unsigned char *UID);
__int16 __stdcall fw_write_dsfid(HANDLE icdev,unsigned char flags,unsigned char DSFID,
								 unsigned char *UID);
__int16 __stdcall fw_lock_dsfid(HANDLE icdev,unsigned char flags,unsigned char DSFID,
								unsigned char *UID);
__int16 __stdcall fw_get_systeminfo(HANDLE icdev,unsigned char flags,
									unsigned char *UID, 
									unsigned char *rlen,unsigned char *rbuffer);
__int16 __stdcall fw_get_securityinfo(HANDLE icdev,unsigned char flags,
									  unsigned char startblock,unsigned char blocknum, 
									  unsigned char *UID, 
									  unsigned char *rlen,unsigned char *rbuffer);


//===============================================
//       typeB at88rf020  card  Functions
//===============================================

__int16 __stdcall fw_request_b(HANDLE icdev,unsigned char _Mode,unsigned char AFI, 
		                       unsigned char N,unsigned char *ATQB);
__int16 __stdcall fw_attrib(HANDLE icdev,unsigned char *PUPI, unsigned char CID);
__int16 __stdcall fw_check_at(HANDLE icdev,unsigned char cid,unsigned char *key);
__int16 __stdcall fw_read_at(HANDLE icdev,unsigned char Adr,unsigned char*key,
							 unsigned char* rbuffer);
__int16 __stdcall fw_write_at(HANDLE icdev,unsigned char Adr,unsigned char* sbuffer);
__int16 __stdcall fw_changekey_at(HANDLE icdev,unsigned char* key);
__int16 __stdcall fw_lock_at(HANDLE icdev,unsigned char Adr,unsigned char*sbuffer);

/*
 *********************************
 * Function: APDU of card
 * PARAMETERS:
   icdev: Handle of reader
   sBuffer: [IN] The command send to card
   sLen :[IN] Length of command
   rBuffer:[OUT] The result buffer returned
   rLen   :[OUT] Length of result
 * RETURN: 0 if success, otherwise error code
 **********************************
 */
__int16 __stdcall fw_CommandLink_at(HANDLE icdev,
										 unsigned char* sBuffer,
										 DWORD sLen,
										 unsigned char* rBuffer,
										 PDWORD rLen);
__int16 __stdcall fw_halt_at(HANDLE icdev,unsigned char cid,unsigned char *key);

__int16 __stdcall fw_count_at(HANDLE icdev,unsigned char cid,unsigned char* key);

//===============================================
//       ISO14443-4 Card
//===============================================

__int16 __stdcall
fw_pro_reset
(
 int ICDev,/* Handle of reader */
 unsigned char *rlen,/* Length of result */
 unsigned char * rbuff /* The information buffer returned */
 );

__int16 __stdcall
fw_pro_commandlink
(
 int ICDev,/* Handle of reader */
 unsigned char slen,/* Length of command */
 unsigned char * sbuff,/* The command for transfering */
 unsigned char *rlen,/* Length of result */
 unsigned char * rbuff,/* The information buffer returned */
 unsigned char tt,/* Relay time [10ms] */
 unsigned char FG /* Unit buffer length, less than 64 */
 );

//===============================================
//       ISO14443 desfire  card  Functions
//===============================================

int _stdcall fw_anticoll2(int icdev,unsigned char _Bcnt,unsigned long *_Snr);
int _stdcall fw_select2(int icdev,unsigned long _Snr);
int __stdcall fw_reset_desfire(int icdev,unsigned char *rlen,unsigned char*rdata);
int __stdcall fw_apdu_desfire(int icdev,unsigned char slen,unsigned char*sdata,
									  unsigned char *rlen,unsigned char*rdata);
//Applications 
int __stdcall fw_authen_desfire(int icdev,unsigned char keyNo, char* 
										key,unsigned char* sessionKey);
int __stdcall fw_authen_desfire_aes(int icdev,unsigned char keyNo, char* 
										key,unsigned char* sessionKey);
int __stdcall fw_getver_desfire(int icdev,unsigned char* rlen,unsigned char* version);
int __stdcall fw_getAIDs_desfire(int icdev,unsigned char* rlen,unsigned char* AIDS);
int __stdcall fw_selectApp_desfire(int icdev,unsigned char* AID);
int __stdcall fw_getKeySetting_desfire(int icdev,unsigned char* rlen,unsigned char*setbuf);
int __stdcall fw_getKeyver_desfire(int icdev,unsigned char keyNo,unsigned char* keyVer);
int __stdcall fw_createApp_desfire(int icdev,unsigned char*AID,unsigned char KeySetting,
										   unsigned char NumOfKey);
int __stdcall fw_delAID_desfire(int icdev,unsigned char* AID);
int __stdcall fw_changeKeySetting_desfire(int icdev,unsigned char newSet,char* sessionKey);
int __stdcall fw_changeKey_desfire(int icdev,unsigned char* sessionKey,unsigned char* curKey,
										   unsigned char keyNo,unsigned char* newkey);
int __stdcall fw_changeKey_desfire_aes(int icdev,unsigned char* sessionKey,unsigned char* curKey,
										   unsigned char keyNo,unsigned char* newkey,unsigned char keyVersion);
int __stdcall fw_getFileIDs_desfire(int icdev,unsigned char* rlen,unsigned char* fileIDs);
int __stdcall fw_getFileProper(int icdev,unsigned char fileNo,unsigned char* rlen,
									   unsigned char * fileProper);
int __stdcall fw_changeFileSetting(int icdev,unsigned char fileNo,unsigned char comSet,
										   unsigned char* accessRight,char* sessionKey);
int __stdcall fw_createDataFile_desfire(int icdev,unsigned char fileNo,unsigned char ComSet,
												unsigned char* AccessRight,unsigned char* FileSize);
int __stdcall fw_createBackupDataFile_desfire(int icdev,unsigned char fileNo,unsigned char ComSet,
												unsigned char* AccessRight,unsigned char* FileSize);
int __stdcall fw_createValueFile_desfire(int icdev,unsigned char fileNo,unsigned char ComSet,
												 unsigned char* AccessRight,unsigned char*
												 lowerLimit,unsigned char* upperLimit,unsigned
												 char* value,unsigned char creditEnabled);
int __stdcall fw_createCsyRecord_desfire(int icdev,unsigned char fileNo,unsigned char comSet,
												 unsigned char* AccessRight,unsigned char* RecordSize,
												 unsigned char* MaxNum);
int __stdcall fw_delFile_desfire(int icdev,unsigned char fileNo);
int __stdcall fw_write_desfire(int icdev,unsigned char fileNo,unsigned int offset,unsigned int length,
									   unsigned char* data,char*sessionKey);
int __stdcall fw_read_desfire(int icdev,unsigned char fileNo,unsigned int offset,unsigned int length,
									  unsigned char* revData,char*sessionKey);
int __stdcall fw_getvalue_desfire(int icdev,unsigned char fileNo,
										  unsigned int* value,char* sessionKey);
int __stdcall fw_credit_desfire(int icdev,unsigned char fileNo,
										unsigned int value,char*sessionKey);
int __stdcall fw_debit_desfire(int icdev,unsigned char fileNo,
									   unsigned int value,char*sessionKey);
int __stdcall fw_writeRecord_desfire(int icdev,unsigned char fileNo,
											 unsigned int offset,unsigned int length,
											 unsigned char* data,char*sessionKey);
int __stdcall fw_readRecord_desfire(int icdev,unsigned char fileNo,
											unsigned int offset,unsigned int length,
											unsigned char* revData,unsigned int* SgRecordlen,
											unsigned int*rlen,char*sessionKey);
int __stdcall fw_clearRecord_desfire(int icdev,unsigned char fileNo);
int __stdcall fw_commitTransfer_desfire(int icdev);
int __stdcall fw_abortTransfer_desfire(int icdev);
int __stdcall fw_formatPICC_desfire(int icdev);

//===============================================
//         24C Commond Functions
//===============================================
int __stdcall fw_read_24c64(int icdev,unsigned int offset,unsigned int length,
									unsigned char* rdata);
int __stdcall fw_write_24c64(int icdev,unsigned int offset,unsigned int length,
									 unsigned char* wdata);
int _stdcall  fw_check_24c64(int icdev);

//===============================================
/*----------ID card Functions--------*/
//===============================================

int _stdcall fw_read_SerialNumberID(int icdev,
											unsigned int _Msec,
											unsigned char* snID);


//===============================================
//         Mifare Plus  Commond Functions
//===============================================
int _stdcall fw_MFPlusL0_WritePerso(int ihic, unsigned char* key, unsigned short keyAddr);
int _stdcall fw_MFPlusL0_CommitPerso(int ihic);
int _stdcall fw_MFPlusL1_AuthenKeyL1(int ihic,unsigned char* key);
int _stdcall fw_MFPlusL1_SwitchToL2(int ihic,unsigned char* key);
int _stdcall fw_MFPlusL1_SwitchToL3(int ihic,unsigned char* key);
int _stdcall fw_MFPlusL2_SwitchToL3(int ihic,unsigned char* key);
int _stdcall fw_MFPlusL3_AuthenL3Key(int ihic,unsigned char* key, unsigned short keyAddr);
int _stdcall fw_MFPlusL3_AuthenSectorKey(int ihic,unsigned char keyType,unsigned int sectorNo,unsigned char* key);
int _stdcall fw_MFPlusL3_UpdateKey(int ihic, unsigned int keyAddr,unsigned char* newKey);
int _stdcall fw_MFPlusL3_ReadWithEncrypt(int ihic, unsigned int blkAddr,unsigned char blkNum,
												unsigned char* rdata,unsigned char flag);
int _stdcall fw_MFPlusL3_WriteWithEncrypt(int ihic, unsigned int blkAddr,unsigned char blkNum,
											  unsigned char* wdata,unsigned char flag);
int _stdcall fw_MFPlusL3_ReadWithPlain(int ihic, unsigned int blkAddr,unsigned char blkNum,
											  unsigned char* rdata);
int _stdcall fw_MFPlusL3_WriteWithPlain(int ihic, unsigned int blkAddr,unsigned char blkNum,
											  unsigned char* wdata);
int _stdcall fw_MFPlusL3_InitVal(int ihic, unsigned int blkAddr,unsigned long value);
int _stdcall fw_MFPlusL3_ReadVal(int ihic, unsigned int blkAddr,unsigned long* value);
int _stdcall fw_MFPlusL3_Increment(int ihic, unsigned int blkAddr,unsigned long value);
int _stdcall fw_MFPlusL3_Decrement(int ihic, unsigned int blkAddr,unsigned long value);

#ifdef __cplusplus
}
#endif

#endif
